﻿var importSamplePreview = {
    context: null,
    dataTable: null,
    config: null,
    previewData: null,
    dataTableColumns: [],
    firstLineContainsHeader: null,
    setDataTableColumns: function () {
        var autoGenerateQuestions = false;

        $.each(importSamplePreview.config.FieldsMappingRows, function (i, e) {
            var name = e.Name;
            var title = name;

            if (!name && importSamplePreview.config.AutoGenerateQuestions) {
                name = e.Field;
                title = "* " + name;
                autoGenerateQuestions = true;
            }

            importSamplePreview.dataTableColumns.push({ "Name": name, "Title": title });
        });

        return autoGenerateQuestions;
    },
    initializeDataTable: function () {
        importSamplePreview.datatable = $("#mappingPreview").a4datatable({
            serverSide: false,
            data: importSamplePreview.previewData,
            columns: importSamplePreview.dataTableColumns
        });
    },
    retrieveConfig: function () {
        importSamplePreview.config = a4.parent().importSampleEditor.getConfiguration(0);
        importSamplePreview.firstLineContainsHeader = importSamplePreview.config.firstLineContainsHeader;
    },
    retrievePreviewData: function () {
        a4.callServerMethod(a4.getSurveyAction("GetImportSamplePreviewData", "Distribute"), { importModel: importSamplePreview.config },
            function (result) {
                importSamplePreview.previewData = result.ImportationPreview;
                var autoGenerateQuestions = importSamplePreview.setDataTableColumns();
                importSamplePreview.initializeDataTable();

                if (autoGenerateQuestions) {
                    $(".autoGenerateQuestionsMessage", importSamplePreview.context).show();
                }
            },
            function (error) {
                modalDialog.close();
                a4.parent().a4.onAjaxPageMethodError(error); //Show error message in parent
            },
            { blockElement: importSamplePreview.context, blockElementTimeout: 800 }
        );
    }
}

$(document).ready(function () {
    importSamplePreview.context = $("#importSamplePreview");
    importSamplePreview.retrieveConfig();
    importSamplePreview.retrievePreviewData();
});